# Pour tracer des courbes
import matplotlib.pyplot as plt
#Pour lire des fichiers csv
import csv
#Pour faire les calculs
from math import sqrt, pi, sin, cos, atan, acos
import numpy as np

#Ouverture du fichier csv
fname='1500trmin_5degs.csv'
file=open(fname)

#Déclaration des variables
tps=[]
roulis=[]
RoulisInit=[]
gamma2=[]
omega2=[]
Nvolant=[]
i2=[]
cg=[]

#Affectation des données du csv dans les variables
try:
    reader=csv.reader(file,delimiter=',')
    for row in reader:
        tps.append(row[0]) #recupere la colonne 0 du csv
        roulis.append(row[6])#...
        RoulisInit.append(row[6])
        gamma2.append(row[5])
        omega2.append(row[7])
        Nvolant.append(row[9])
        i2.append(row[21])
        cg.append(row[36])
finally:
    file.close()

#Suppression du nom des colonnes
tps=tps[1:]
roulis=roulis[1:]
RoulisInit=RoulisInit[1:]
gamma2=gamma2[1:]
N2=omega2[1:]
omega2=omega2[1:]
Nvolant=Nvolant[1:]
i2=i2[1:]
cg=cg[1:]

for k in range(len(tps)):
    tps[k]=float(tps[k])
    roulis[k]=float(roulis[k])
    RoulisInit[k]=float(RoulisInit[k])
    gamma2[k]=pi*float(gamma2[k])/180
    N2[k]=float(N2[k])
    omega2[k]=float(omega2[k])*pi/180
    Nvolant[k]=float(Nvolant[k])*pi/30
    i2[k]=float(i2[k])
    cg[k]=float(cg[k])

#Fonction Moyenne Glissante si besoin
def filtre_mg(u,n):
    N=len(u)
    res=np.ones(N)
    somme=0
    for i in range(N):
        if i <= n-1:
            somme+=float(u[i])
            res[i]=somme/(i+1)
        else:
            somme+=float(u[i])-float(u[i-n])
            res[i]=somme/n
    return res

#omega2=filtre_mg(omega2,50)

#Centre de masse du bateau
a1=14.87
b1=-0.27
c1=-29.86
#m1=13.1234
m1=13.4
#Centre de masse du cadre
lambda1=82
a2=-0.36
b2=-1.74
c2=17.74
m2=1.898
#Centre de masse du volant
l3=2.05
m3=4.3581
#Centre de masse de la surcharge
a1e=13
b1e=0
c1e=-59.2
a4e=-100.6
b4e=-0.23
c4e=-64.87
m4=2.0598
#Moment d'inertie
IA2=0.00115
IC2=0.0
IA3=0.01061
IC3=0.01265


## Correction de l'angle de roulis
# on récupère l'indice du début du mvt du cadre (N>=2 deg/s)
k=0
while N2[k]<2:
    indice_debut=k
    k+=1
# on supprime tous les valeurs après l'indice de début
del RoulisInit[indice_debut:]
# on calcul l'angle moyen
RoulisInitMoy=sum(RoulisInit)/len(RoulisInit)
# on retire l'angle moyen à roulis
for k in range(len(roulis)):
    roulis[k]-=RoulisInitMoy

## Calcul du couple gyroscopique







## Tracé des courbes

fig, ((ax0, ax2), (ax1, ax3)) = plt.subplots(2, 2)
fig.suptitle('Identification du couple gyroscopique')

ax0.plot(tps, roulis, '-r', tps, N2, '-b')
ax0.set_xlim([95,137])
ax0.set_xlabel('Temps (s)')
ax0.legend(['Angle de roulis (deg)','Vitesse inclinaison volant (deg/s)'])


plt.show()
